% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{similarity}
\alias{similarity}
\title{Calculate the similarity between two vectors of logicals.}
\usage{
similarity(x, y, measure)
}
\arguments{
\item{x, y}{Logical or numeric vectors.}

\item{measure}{Similarity measure ("simple_matching", "jaccard", or "tanimoto")}
}
\value{
The similarity between \code{x} and \code{y}.
}
\description{
Calculate the similarity between two vectors of logicals.
}
\details{
Input vectors must consist of logical or numeric elements TRUE,FALSE or 0,1
(not factors). Similarity measures in this package are based on those defined in
the \href{http://dmg.org/pmml/v4-2-1/ClusteringModel.html#xsdElement_ComparisonMeasure}{PMML specification}.
Similarity ranges from 0 (no similarity) to 1 (identical).

For logical vectors \code{x} and \code{y}, we define the following:\cr

\code{a11} = number of times where x_i=1 and y_i=1\cr
\code{a10} = number of times where x_i=1 and y_i=0\cr
\code{a01} = number of times where x_i=0 and y_i=1\cr
\code{a00} = number of times where x_i=0 and y_i=0\cr

Similarities are calculated using the following formulas:\cr

Simple matching: \eqn{(a11 + a00) / (a11 + a10 + a01 + a00)}\cr\cr
Jaccard: \eqn{(a11) / (a11 + a10 + a01)}\cr\cr
Tanimoto: \eqn{ (a11 + a00) / (a11 + 2 * (a10 + a01) + a00)}\cr\cr
}
\examples{
similarity(c(0,1,1),c(0,0,1),"simple_matching")
similarity(c(0,1,1),c(0,0,1),"jaccard")
similarity(as.logical(c(0,1,1)),as.logical(c(0,0,1)),"tanimoto")

}
\seealso{
\code{\link{distance}},
\href{http://dmg.org/pmml/v4-3/ClusteringModel.html#xsdElement_ComparisonMeasure}{PMML comparison measures}
}
