% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{npe_groundcover}
\alias{npe_groundcover}
\title{Get ground cover and other variables}
\usage{
npe_groundcover(
  neon_div_object,
  scale = "plot",
  verbose = FALSE,
  pc_na_value = 0.5,
  timescale = "annual"
)
}
\arguments{
\item{neon_div_object}{the raw diversity data downloaded using
neonPlantEcology::download_plant_div() or the function
neonUtilities::loadByProduct() with the dpID arguement set to "DP1.10058.001".}

\item{scale}{the spatial scale of aggregation. Can be "1m", "10m", "100m",
"plot" or "site". default is "plot".}

\item{verbose}{if true, prints details of which eventID errors were fixed into the console}

\item{pc_na_value}{sometimes the raw data from neon will have NA's in the percent
cover cells. This is assumed to be a data entry error and is set to 0.5 by
default.}

\item{timescale}{The temporal scale of aggregation. Can be "all", "annual" or
"subannual" in the case of multiple sampling bouts per year. Defaults to "annual".}
}
\value{
a data frame with each row a single observation of ground cover at the
spatial and temporal scale chosen by the user.
}
\description{
Get ground cover and other variables
}
\examples{
data("D14")
groundcover <- npe_groundcover(D14)
}
