% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_store.R
\name{neon_store}
\alias{neon_store}
\title{import neon data into a local database}
\usage{
neon_store(
  table = NA,
  product = NA,
  type = NA,
  dir = neon_dir(),
  db = neon_db(neon_db_dir(), read_only = FALSE),
  n = 500L,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{table}{Include only files matching this table name (or regex pattern).
(optional).}

\item{product}{A NEON \code{productCode} or list of product codes, see examples.}

\item{type}{Should we prefer the basic or expanded version of this product?
Note that not all products have expanded formats.}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \code{\link[tools:userdir]{tools::R_user_dir()}}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}

\item{db}{A connection to a write-able relational database backend,
see \code{\link[=neon_db]{neon_db()}}.}

\item{n}{number of files that should be read per iteration}

\item{quiet}{show progress?}

\item{...}{
  Arguments passed on to \code{\link[=neon_read]{neon_read}}
  \describe{
    \item{\code{sensor_metadata}}{logical, default TRUE. Should we add
metadata fields from file names of sensor data into the table?  Adds
DomainID, SiteID, horizontalPosition, verticalPosition, and publicationDate.
Results in slower parsing.}
    \item{\code{keep_filename}}{Should we include a column indicating the original
file name for each row?  Can be a useful source of additional metadata that
NEON may omit from the raw files (i.e. \code{siteID}), but will also result in
slower parsing.  Default \code{FALSE}.}
    \item{\code{altrep}}{enable or disable altrep.  Logical, default \code{FALSE}. Setting to
\code{TRUE} can speed up reading, but may cause \link[vroom:vroom]{vroom::vroom} to throw
\verb{mapping error: Too many open files}.}
    \item{\code{files}}{optionally, specify a vector of file paths directly (e.g. as
provided from \link{neon_index}) and specify \code{table} argument as NULL.}
    \item{\code{ext}}{only match files with this file extension(s)}
    \item{\code{timestamp}}{only match timestamps prior this. See details in \code{\link[=neon_index]{neon_index()}}.
Should be a datetime POSIXct object (or coerce-able string)}
    \item{\code{start_date}}{Download only files as recent as (\code{YYYY-MM-DD}). Leave
as \code{NA} to download up to the most recent available data.}
    \item{\code{end_date}}{Download only files up to end_date (\code{YYYY-MM-DD}). Leave as
\code{NA} to download all prior data.}
    \item{\code{site}}{4-letter site code(s) to filter on. Leave as \code{NA} to search all.}
    \item{\code{release}}{Select only data files associated with a particular release tag,
see \url{https://www.neonscience.org/data-samples/data-management/data-revisions-releases},
e.g. "RELEASE-2021".  Releases are associated with a specific DOI and the promise that
files associated with a particular release will not change.}
  }}
}
\value{
the index of files read in (invisibly)
}
\description{
import neon data into a local database
}
