% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_ops.R
\name{build_exchangeable_matrix}
\alias{build_exchangeable_matrix}
\title{Build an exchangeable matrix of sparseMatrix class}
\usage{
build_exchangeable_matrix(n, phi, directed = TRUE, dyads = NULL)
}
\arguments{
\item{n}{Number of actors in the network, scalar numeric.}

\item{phi}{Appropriate-length vector of parameters, must be length 5 or 6 for directed=\code{TRUE} or length 2 or 3 for directed=\code{FALSE}.}

\item{directed}{Optional logical indicator of whether input data is for a directed network, default is \code{TRUE}. Undirected data format is lower triangle of adjacencey matrix.}

\item{dyads}{Optional numeric vector of dyads to subset the matrix to.}
}
\value{
\item{out}{Exchangeable matrix.}
}
\description{
Build an exchangeable matrix of sparseMatrix class
}
\details{
This function builds a covariance matrix in the exchangeable class from the vector of parameters input. See Marrs et.al. (2017).
}
\examples{
n <- 5
build_exchangeable_matrix(n, rphi(n, seed=1))

}
\references{
Marrs, F. W., Fosdick, B. K., & McCormick, T. H., (2017). Standard errors for regression on relational data with exchangeable errors. arXiv preprint arXiv:1701.05530.
}
\seealso{
\code{\link{rphi}}, \code{\link{invert_exchangeable_matrix}}
}
\keyword{external}
