% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{eval_dcsbm_loglr}
\alias{eval_dcsbm_loglr}
\title{Log-likelihood ratio of two DCSBMs (fast with poi = TRUE)}
\usage{
eval_dcsbm_loglr(A, labels, poi = TRUE, eps = 1e-06)
}
\arguments{
\item{A}{adjacency matrix}

\item{labels}{a matrix with two columns representing two different label
vectors}

\item{poi}{whether to use Poisson version of likelihood (instead of Bernoulli)}

\item{eps}{truncation threshold for the Bernoulli likelihood, used when
parameter phat is close to 1 or 0.}
}
\value{
log-likelihood ratio
}
\description{
Computes the log-likelihood ratio of one DCSBM relative to another, using
estimated parameters \code{B} and \code{theta} based on the given label vectors.
}
\details{
The log-likehood ratio is computed between two DCSBMs specified by the columns
of \code{labels}. The function computes the log-likelihood ratio of the model with
\code{labels[ , 2]} w.r.t. the model with \code{labels[ , 1]}. This is often used with two
label vectors fitted using different number of communities (say \code{K} and \code{K+1}).

When \code{poi} is set to \code{TRUE}, the function uses fast sparse matrix computations
and is scalable to large sparse networks.
}
\seealso{
\link{eval_dcsbm_like}, \link{eval_dcsbm_bic}
}
\keyword{mod_sel}
