% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_net}
\alias{plot_net}
\title{Plot a network}
\usage{
plot_net(
  gr,
  community = NULL,
  color_map = NULL,
  extract_lcc = TRUE,
  heavy_edge_deg_perc = 0.97,
  coord = NULL,
  vsize_func = function(deg) log(deg + 3) * 1,
  vertex_border = FALSE,
  niter = 1000,
  vertex_alpha = 0.4,
  remove_loops = TRUE,
  make_simple = FALSE,
  ...
)
}
\arguments{
\item{gr}{the network as an igraph object}

\item{community}{community assignment; vector of node labels}

\item{color_map}{color palette for clusters in 'gr'}

\item{extract_lcc}{Extract largest connected component or not}

\item{heavy_edge_deg_perc}{Degree percentile threshold for determining heavy edges}

\item{coord}{Optional starting positions for the vertices.
If this argument is not NULL then it should be an appropriate matrix of starting coordinates.}

\item{vsize_func}{function to determine the size of node size}

\item{vertex_border}{whether to show the border of vertex or not}

\item{niter}{number of iteration for FR layout computation}

\item{vertex_alpha}{factor modifying the opacity alpha of vertex; typically in [0,1]}

\item{remove_loops}{whether to remove loops in the network}

\item{make_simple}{whether to simplify edge weight calculation}

\item{...}{other settings}
}
\value{
A network plot
}
\description{
Plot a network using degree-modulated node sizes, community colors and other enhancements
}
