% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral.R
\name{spec_repr}
\alias{spec_repr}
\title{Spectral Representation}
\usage{
spec_repr(A, K, type = "lap", tau = 0.25, ignore_first_col = FALSE)
}
\arguments{
\item{A}{Adjacency matrix (n x n)}

\item{K}{Number of communities}

\item{type}{("lap" | "adj" | "adj2") Whether to use Laplacian or
adjacency-based spectral clustering}

\item{tau}{Regularization parameter for the Laplacian}

\item{ignore_first_col}{whether to ignore the first eigen vector}
}
\value{
The n x K matrix resulting from a spectral embedding of the network into
R^K
}
\description{
Provides a spectral representation of the network (with regularization)
based on the adjacency or Laplacian matrices
}
\keyword{net_repr}
