% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-auth.R
\name{ns_client}
\alias{ns_client}
\title{Create an OAuth2 Client for Nettskjema API}
\usage{
ns_client(
  client_id = Sys.getenv("NETTSKJEMA_CLIENT_ID"),
  client_secret = Sys.getenv("NETTSKJEMA_CLIENT_SECRET"),
  client_name = "nettskjemar"
)
}
\arguments{
\item{client_id}{[character] The client ID provided by Nettskjema.}

\item{client_secret}{[character] The client secret provided
by Nettskjema.}

\item{client_name}{[character] An optional name for the
client (default = "nettskjemar").}
}
\value{
A configured `httr2::oauth_client` object.
}
\description{
This function initializes an OAuth2 client using
 the `httr2::oauth_client` function. It is used to
authenticate and interact with the Nettskjema API.
}
\examples{
\dontrun{
# Example: Initialize an OAuth2 client for Nettskjema
client <- ns_client(
  client_id = "your_client_id",
  client_secret = "your_client_secret"
)

# Using a custom client name
client <- ns_client(
  client_id = "your_client_id",
  client_secret = "your_client_secret",
  client_name = "custom_client_name"
)
}
}
