% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_treenetdf.R
\name{as_treenetdf}
\alias{as_treenetdf}
\title{Convert one of numerous data types to treeNetwork's 'native' treenetdf form}
\usage{
as_treenetdf(data = NULL, ...)
}
\arguments{
\item{data}{a tree network description in one of numerous forms (see
details).}

\item{...}{other arguments that will be passed on to as_treenetdf}
}
\description{
The \code{treeNetwork} function uses a 'native' data format that consists of a data
frame with minimally 2 vectors/columns, one named \code{'nodeId'} and one named
\code{'parentId'}. Other columns in the data frame are also passed on to the
JavaScript code and attached to the elements in the D3 visualization so that
they can potentially be accessed by other JavaScript functions. This is an
advantageous format because:
\itemize{
\item it's an easy to use and understand R-like format
\item a hierarchical network can be succinctly defined by a list of each unique
node and its parent node
\item since each row defines a unique node, additional columns can be added to
add node-specific properties
\item in a hierarchical network, every link/edge can be uniquely identified by
the node which it leads to, therefore each link/edge can also be specifically
addressed by adding columns for formatting of the incoming link
}

\code{as_treenetdf} can convert from any of the following data types:
\itemize{
\item \code{leafpathdf} (table)--\code{parent|parent|node}--\code{data.frame}
\item hierarchical nested list (JSON)
\item \code{hclust}
\item \code{data.tree} Node
\item igraph
\item ape \code{phylo}
}
}
\examples{
links <- read.csv(header = TRUE, stringsAsFactors = FALSE, text = '
                   source,target,name
                   1,,one
                   2,1,two
                   3,1,three
                   4,1,four
                   5,2,five
                   6,2,six
                   7,2,seven
                   8,6,eight')
                   
 # Convert data
 as_treenetdf(links, cols = c(nodeId = 'source', parentId = 'target'))
 
 # Graph (calls as_treenetdf internally)
 treeNetwork(links, cols = c(nodeId = 'source', parentId = 'target'))

}
