% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_treenetdf.R
\name{as_treenetdf.data.frame}
\alias{as_treenetdf.data.frame}
\title{Convert a data.frame to a \code{treenetdf}}
\usage{
\method{as_treenetdf}{data.frame}(
  data,
  cols = setNames(names(data), names(data)),
  df_type = "treenetdf",
  subset = names(data),
  root,
  ...
)
}
\arguments{
\item{data}{a tree network description in one of numerous forms (see
details).}

\item{cols}{named character vector specifying the names of columns to be
converted to the standard \code{treenetdf} names.}

\item{df_type}{character specifying which type of data frame to convert. Can
be \code{treenetdf} or
\code{leafpathdf}.}

\item{subset}{character vector specifying the names of the columns (in order)
that should be used to define the hierarchy.}

\item{root}{root name.}

\item{...}{arguments to pass to methods.}
}
\description{
Convert a data.frame to a \code{treenetdf}
}
