% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkFun_edge_LSM.R
\name{sem.net.edge.lsm}
\alias{sem.net.edge.lsm}
\title{Fit a Structural Equation Model (SEM) with both network and non-network data by transforming nonnetwork data into paired values corresponding to network latent distance pairs.}
\usage{
sem.net.edge.lsm(
  model = NULL,
  data = NULL,
  type = "difference",
  latent.dim = 2,
  data.rescale = FALSE,
  ordered = NULL,
  sampling.weights = NULL,
  group = NULL,
  cluster = NULL,
  netstats.rescale = FALSE,
  constraints = "",
  WLS.V = NULL,
  NACOV = NULL,
  ...
)
}
\arguments{
\item{model}{A model string specified in lavaan model syntax that includes relationships among the network and non-network variables.}

\item{data}{A list containing the data. The list has two named components, "network" and "nonnetwork"; "network" is a list of named adjacency matrices for the network data, and "nonnetwork" is the dataframe of non-network covariates.}

\item{type}{"difference" for using the difference between the network statistics of the two actors as the edge covariate; "average" for using the average of the network statistics of the two actors as the edge covariate.}

\item{latent.dim}{The number of network latent dimensions to use in extracting latent positions of network nodes.}

\item{data.rescale}{TRUE or FALSE, whether to rescale the whole dataset (with restructured network and nonnetwork data) to have mean 0 and standard deviation 1 when fitting it to SEM, default to FALSE.}

\item{ordered}{Parameter same as "ordered" in the lavaan sem() function; whether to treat data as ordinal.}

\item{sampling.weights}{Parameter same as "sampling.weights" in the lavaan sem() function; whether to apply weights to data.}

\item{group}{Parameter same as "group" in the lavaan sem() function; whether to fit a multigroup model.}

\item{cluster}{Parameter same as "cluster" in the lavaan sem() function; whether to fit a cluster model.}

\item{netstats.rescale}{TRUE or FALSE, whether to rescale the network statistics to have mean 0 and standard deviation 1, default to FALSE.}

\item{constraints}{Parameter same as "constraints" in the lavaan sem() function; whether to apply constraints to the model.}

\item{WLS.V}{Parameter same as "WLS.V" in the lavaan sem() function; whether to use WLS.V estimator.}

\item{NACOV}{Parameter same as "NACOV" in the lavaan sem() function; whether to use NACOV estimator.}

\item{...}{Optional arguments for the sem() function.}
}
\value{
A networksem object containing the updated model specification string with the reconstructed network statistics as variables, a lavaan SEM output object, and a latentnet ergm object.
}
\description{
Fit a Structural Equation Model (SEM) with both network and non-network data by transforming nonnetwork data into paired values corresponding to network latent distance pairs.
}
\examples{
\donttest{
set.seed(10)
nsamp = 20
lv1 <- rnorm(nsamp)
net <- ifelse(matrix(rnorm(nsamp^2) , nsamp, nsamp) > 1, 1, 0)
lv2 <- rnorm(nsamp)
nonnet <- data.frame(x1 = lv1*0.5 + rnorm(nsamp),
                     x2 = lv1*0.8 + rnorm(nsamp),
                     x3 = lv2*0.5 + rnorm(nsamp),
                     x4 = lv2*0.8 + rnorm(nsamp))

model <-'
  lv1 =~ x1 + x2
  lv2 =~ x3 + x4
  net ~ lv1
  lv2 ~ net
'
data = list(network = list(net = net), nonnetwork = nonnet)
set.seed(100)
res <- sem.net.edge.lsm(model = model, data = data, latent.dim = 1)
summary(res)
}
}
