% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty_estimation.R
\name{.combine_uncertainties_sampling}
\alias{.combine_uncertainties_sampling}
\title{Internal helper: combine epistemic and aleatoric uncertainties via mixture sampling}
\usage{
.combine_uncertainties_sampling(
  lwr_mat,
  upr_mat,
  mean_mat,
  alpha = 0.05,
  inner_samples = 50,
  centerline = NULL
)
}
\arguments{
\item{lwr_mat}{Matrix \code{[passes, n_obs]} of lower quantile predictions.}

\item{upr_mat}{Matrix \code{[passes, n_obs]} of upper quantile predictions.}

\item{mean_mat}{Matrix \code{[passes, n_obs]} of mean predictions.}

\item{alpha}{Coverage level (default 0.05).}

\item{inner_samples}{Number of Normal samples per pass/observation.}

\item{centerline}{Optional vector of deterministic mean predictions (overrides pass-mean).}
}
\value{
A \code{data.frame} with columns:
\itemize{
\item \code{lwr}, \code{upr}: lower/upper predictive interval.
\item \code{var_epistemic}: epistemic variance (across passes).
\item \code{var_aleatoric}: average aleatoric variance.
\item \code{var_total}: sum of epistemic and aleatoric variances.
}
}
\description{
Combine uncertainty estimates from multiple MC Dropout passes where each pass
produces quantile bounds and a mean. For each observation, samples are drawn from
Normal approximations of aleatoric noise across passes, yielding a predictive
mixture distribution.
}
\author{
Ines Ortega-Fernandez, Marta Sestelo
}
\keyword{internal}
