% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_feature_NN.R
\name{validate_activation}
\alias{validate_activation}
\title{Validate/resolve a Keras activation}
\usage{
validate_activation(activation)
}
\arguments{
\item{activation}{character or function. If character, must be a valid
tf.keras activation identifier (e.g., "relu", "gelu", "swish", ...).}
}
\value{
a callable activation (Python callable) or the original R function.
}
\description{
Validate/resolve a Keras activation
}
\examples{
\dontrun{
library(neuralGAM)
act <- neuralGAM:::validate_activation("relu")     # ok
act <- neuralGAM:::validate_activation(function(x) x)  # custom
}
}
\keyword{internal}
