% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gns.R
\name{plot_gns}
\alias{plot_gns}
\title{Gene summary plot of neuroimaGene object}
\usage{
plot_gns(ng_obj, maxGns = 15, title = NA, verbose = FALSE)
}
\arguments{
\item{ng_obj}{NeuroimaGene Object}

\item{maxGns}{maximum number of genes to visualize. default=15}

\item{title}{optional title tag for the plot}

\item{verbose}{print runtime messages to R console. Default to FALSE}
}
\value{
a ggplot class plot detailing NIDPs per gene, colored by brain measure type
}
\description{
Generates an overview plot of the neuroimaGene object according to each gene input.
}
\examples{
gene_list <- c('TRIM35', 'PROSER3', 'EXOSC6', 'PICK1', 'UPK1A', 'ESPNL', 'ZIC4')
ng <- neuroimaGene(gene_list, atlas = NA, mtc = 'BH', vignette = TRUE)
plot_gns(ng)

}
\keyword{neuroimaging}
