% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nvd-class.R
\name{var2_nvd}
\alias{var2_nvd}
\title{Fréchet Variance of Network-Valued Data from Inter-Point Distances}
\usage{
var2_nvd(x, representation = "adjacency", distance = "frobenius")
}
\arguments{
\item{x}{An \code{\link{nvd}} object listing a sample of networks.}

\item{representation}{A string specifying the graph representation to be
used. Choices are adjacency, laplacian, modularity, graphon. Default is
adjacency.}

\item{distance}{A string specifying the distance to be used. Possible choices
are: hamming, frobenius, spectral or root-euclidean. Default is frobenius.}
}
\value{
A positive scalar value evaluating the variance based on inter-point
distances.
}
\description{
This function computes the Fréchet variance using exclusively inter-point
distances. As such, it can accommodate any pair of representation and
distance.
}
\examples{
gnp_params <- list(p = 1/3)
x <- nvd(model = "gnp", n = 10L, model_params = gnp_params)
var2_nvd(x = x, representation = "graphon", distance = "frobenius")
}
