% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uigd.R
\name{uigd}
\alias{uigd}
\alias{duigd}
\alias{puigd}
\alias{quigd}
\alias{ruigd}
\title{Unit Inverse Gaussian Distribution}
\usage{
duigd(x, mu, lambda = 1, log = FALSE)

puigd(q, mu, lambda = 1, lower.tail = TRUE, log.p = FALSE)

quigd(p, mu, lambda = 1, lower.tail = TRUE)

ruigd(n, mu, lambda = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{a mean parameter.}

\item{lambda}{a scale parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{duigd} gives the density, \code{puigd} gives the distribution
function, \code{quigd} gives the quantile function and \code{ruigd} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the Unit Inverse Gaussian distribution \code{mean} and \code{scale}.
}
\details{
The Unit Inverse Gaussian distribution \code{scale}
parameter \eqn{\lambda} and \code{mean}
parameter \eqn{\mu}, has density
\deqn{f\left( x\right) =\sqrt{\frac{\lambda }{2\pi }}
\frac{1}{x^{3/2}}e^{-\frac{ \lambda }{2\mu ^{2}x}\left( x-\mu \right) ^{2}},}
where
\deqn{x>0,~\mu ,\lambda >0.}
}
\examples{
library(new.dist)
duigd(1, mu=2, lambda=3)
puigd(1,mu=2,lambda=3)
quigd(.1,mu=2,lambda=3)
ruigd(10,mu=2,lambda=3)
}
\references{
Ghitany, M., Mazucheli, J., Menezes, A. ve Alqallaf, F., 2019,
\emph{The unit-inverse Gaussian distribution: A new alternative to two-parameter}
\emph{distributions on the unit interval, Communications in Statistics-Theory and}
\emph{Methods}, 48 (14), 3423-3438.
}
