% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMVC.R
\name{IMVCFDR}
\alias{IMVCFDR}
\title{Integrated Mean Variance Correlation Based FDR Control}
\usage{
IMVCFDR(y, x, K, NN = 3, numboot, timeboot, true_signal, null_method, alpha)
}
\arguments{
\item{y}{is the response vector}

\item{x}{is the covariate matrix}

\item{K}{is the number of quantile levels}

\item{NN}{is the number of B spline basis, default is 3}

\item{numboot}{is the size of bootstrap samples}

\item{timeboot}{is the number of bootstrap times for computing standard deviation of the IMVC}

\item{true_signal}{is the true active set}

\item{null_method}{is the estimation method for proportion of true null hypotheses. Choices are "lfdr", "mean", "hist" or "convest"}

\item{alpha}{is the nominal FDR level}
}
\value{
A list of FDP, power and selected variables
}
\description{
This function is used for FDR control with integrated mean variance correlation
}
\examples{
require("mvtnorm")
n=200
p=20
pho1=0.5
mean_x=rep(0,p)
sigma_x=matrix(NA,nrow = p,ncol = p)
for (i in 1:p) {
 for (j in 1:p) {
   sigma_x[i,j]=pho1^(abs(i-j))
 }
}
x=rmvnorm(n, mean = mean_x, sigma = sigma_x,method = "chol")
x1=x[,1]
x2=x[,2]
x3=x[,3]
y=2*x1+2*x2+2*x3+rnorm(n)

IMVCFDR(y,x,K=5,numboot=100,timeboot=20,true_signal=c(1,2,3),null_method="hist",alpha=0.2)
}
