% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hist.R
\docType{methods}
\name{hist}
\alias{hist}
\alias{hist,CompositionMatrix-method}
\title{Histogram of Compositional Data}
\usage{
\S4method{hist}{CompositionMatrix}(
  x,
  ...,
  select = 1,
  breaks = "Sturges",
  freq = FALSE,
  labels = FALSE,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes
)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Further graphical parameters.}

\item{select}{A length-one \code{vector} of column indices.}

\item{breaks}{An object specifying how to compute the breakpoints
(see \code{\link[graphics:hist]{graphics::hist()}}).}

\item{freq}{A \code{\link{logical}} scalar: should absolute frequencies (counts) be
displayed? If \code{FALSE} (the default), relative frequencies (probabilities)
are displayed (see \code{\link[graphics:hist]{graphics::hist()}}).}

\item{labels}{A \code{\link{logical}} scalar: should labels be drawn on top of bars?
If \code{TRUE}, draw the counts or rounded densities; if \code{labels} is a
\code{character} vector, draw itself.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}
}
\value{
\code{hist()} is called for its side-effects: is results in a graphic being
displayed (invisibly return \code{x}).
}
\description{
Produces an histogram of univariate ILR data (see Filzmoser \emph{et al.}, 2009).
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Boxplot plot
hist(coda, select = "A")
hist(coda, select = "B")
}
\references{
Filzmoser, P., Hron, K. & Reimann, C. (2009). Univariate Statistical
Analysis of Environmental (Compositional) Data: Problems and Possibilities.
\emph{Science of The Total Environment}, 407(23): 6100-6108.
\doi{10.1016/j.scitotenv.2009.08.008}.
}
\seealso{
Other plot methods: 
\code{\link{as_graph}()},
\code{\link{barplot}()},
\code{\link{boxplot}()},
\code{\link{pairs}()},
\code{\link{plot}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
