% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{bin_env}
\alias{bin_env}
\title{Helper function to prepare bin tables}
\usage{
bin_env(overall_range, M_range, sp_range, bin_size)
}
\arguments{
\item{overall_range}{(numeric) minimum and maximum values of all species and
Ms to be analyzed.}

\item{M_range}{matrix of ranges of environmental values in M for all species.
Columns must be minimum and maximum, and rows correspond to species.}

\item{sp_range}{matrix of ranges of environmental values in occurrences
for all species. Columns must be minimum and maximum, and rows correspond to
species.}

\item{bin_size}{(numeric) size of bins. Range of environmental values to
be considered when creating each character in bin tables. See details.}
}
\value{
A character matrix (table of characters) containing bins for a given variable
and for all species considered. See more details in \code{\link{bin_tables}}.
}
\description{
Helper function to prepare bin tables
}
\details{
The argument \code{bin_size} helps to create characters that represent not
only one value of an environmental variable, but a range of environmental
conditions. For instance, if a variable of precipitation in mm is used, a
value of 10 for \code{bin_size} indicates that each character will represent
a class that correspond to 10 continuous values of precipitation (e.g., from
100 to 110 mm).
}
\examples{
# example
o_range <- c(1, 25)
m_range <- rbind(c(5, 15), c(10, 23), c(4, 20))
s_range <- rbind(c(7, 15), c(12, 21), c(3, 18))

# bin preparation
bins <- bin_env(overall_range = o_range, M_range = m_range,
                sp_range = s_range, bin_size = 1)
}
