% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dLogisticGrowth2.R
\name{dLogisticGrowth2}
\alias{dLogisticGrowth2}
\alias{rLogisticGrowth2}
\title{Logistic Growth Model (parametrisation with inflection point)}
\usage{
dLogisticGrowth2(x, a, b, m, r, log)

rLogisticGrowth2(n, a, b, m, r)
}
\arguments{
\item{x}{vector of calendar years (in BP).}

\item{a}{lower (earliest) limit of the distribution (in BP).}

\item{b}{upper (latest) limit of the distribution (in BP).}

\item{m}{inflection point in BP (i.e. point with the highest growth rate).}

\item{r}{intrinsic growth rate.}

\item{log}{TRUE or 1 to return log probability. FALSE or 0 to return probability.}

\item{n}{number of random draws. Currently only n = 1 is supported, but the argument exists for standardization of "r" functions.}
}
\value{
For \code{dLogisticGrowth2}: the probability (or likelihood) or log probability of an observed date x (in Cal BP). For \code{rLogisticGrowth2} a simulated date in Cal BP.
}
\description{
Density and random generation of a logistic growth model distribution with alternative parametrisation.
}
\details{
This is an alternative parametrisation of \code{dLogisiticGrowth}, where \code{m} is equal to \code{log(-(k-1)/k)/r}.
}
\examples{
p = list(m=4500,r=0.007)
modelPlot(model = dLogisticGrowth2,a=6000,b=4000,params=p,alpha = 1)
}
\author{
Enrico Crema
}
