% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dLogHalfflat.R
\name{dLogHalfflat}
\alias{dLogHalfflat}
\alias{rLogHalfflat}
\title{Log transformed half-flat distribution .}
\usage{
dLogHalfflat(x, log = 0)

rLogHalfflat(n = 1)
}
\arguments{
\item{x}{A continuous random variable on the real line, where y=exp(x) and y ~ dhalfflat().}

\item{log}{Logical flag to toggle returning the log density.}

\item{n}{Number of random variables. Currently limited to 1, as is common in nimble. See ?replicate for an alternative. Note, NAN will be returned because distribution is improper.}
}
\value{
A value proportional to the density, or the log of that value, of x, such that x = log(y) and y ~ dhalfflat().
}
\description{
\code{dLogHalfflat} and \code{rLogHalfflat} provide a log-transformed half-flat distribution.
Note, both dhalfflat and dLogHalfflat are improper. Thus, rLogHalfflat returns NAN, just as rhalfflat does.
}
\examples{

oldpar <- par()
par(mfrow=n2mfrow(2))
## Plot 1
curve(dhalfflat(x), -11, 11, n=1001, col="red", lwd=3, xlab="y = exp(x)", ylab="dhalfflat(y)")
## Plot 2: back-transformed
curve(dLogHalfflat(x), -5, 1.5, n=1001, col="red", lwd=3, , xlab="x = log(y)")
abline(v=0:1, h=c(0,1,exp(1)), col="grey")
par(oldpar)

}
\author{
David R.J. Pleydell
}
