% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWindowIndex.R
\name{getWindowIndex}
\alias{getWindowIndex}
\title{Get window index}
\usage{
getWindowIndex(curCoords, lowerCoords, upperCoords)
}
\arguments{
\item{curCoords}{Vector of coordinates of a single spatial point}

\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of a set of windows. One row for each window.}
}
\value{
Index of the window where the given point falls; -1 is returned if the point does not fall in any window.
}
\description{
From a set of windows, find the index of the window into which a given point falls. 
Can be applied to detection and habitat windows.
}
\examples{

sourceCoords <- c(1.5,2.2)
lowerCoords <- cbind(c(0,1,3,0),c(0,1,2,2))
upperCoords <- cbind(c(1,3,5,3),c(1,2,4,4))
getWindowIndex(sourceCoords, lowerCoords, upperCoords)

}
\author{
Pierre Dupont
}
