% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmeU-package.R
\docType{data}
\name{armd}
\alias{armd}
\title{armd Data (867 x 8)}
\format{
A data frame with 867 rows and 8 columns:
\describe{
  \item{subject}{A factor with 234 levels: \code{1}, \code{2}, \code{3}, \code{4}, \code{6}, ..., \code{240}}
  \item{treat.f}{A factor with 2 levels: \code{Placebo}, \code{Active}}
  \item{visual0}{An integer vector with values ranging from 20 to 85}
  \item{miss.pat}{A factor with 8 levels: \code{----}, \code{---X}, \code{--X-}, \code{--XX}, \code{-XX-}, ..., \code{X-XX}}
  \item{time.f}{A factor with 4 levels: \code{4wks}, \code{12wks}, \code{24wks}, \code{52wks}}
  \item{time}{A numeric vector with values 4, 12, 24, 52}
  \item{visual}{An integer vector with values ranging from 3 to 85}
  \item{tp}{A numeric vector with values 1, 2, 3, 4 corresponding to time points 4, 12, 24, 52, respectively}
}
}
\source{
Pharmacological Therapy for Macular Degeneration Study Group (1997).
  Interferon alpha-IIA is ineffective for patients with choroidal
  neovascularization secondary to age-related macular degeneration. Results of
  a prospective randomized placebo-controlled clinical trial. Archives of
  Ophthalmology, 115, 865-872.
}
\usage{
armd
}
\description{
Data from Age-Related Macular Degeneration (ARMD) clinical trial
}
\details{
The ARMD data arise from a randomized multi-center clinical trial comparing
an experimental treatment (interferon-alpha) versus placebo for patients
diagnosed with ARMD.
}
\examples{
library(nlmeU)
data(armd)
summary(armd)
}
\seealso{
\code{\link{armd0}}, \code{\link{armd.wide}}
}
\keyword{datasets}
