% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linshrink.R
\name{linshrink}
\alias{linshrink}
\title{Linear-shrinkage estimator of population eigenvalues.}
\usage{
linshrink(X, k = 0)
}
\arguments{
\item{X}{A data matrix.}

\item{k}{(Optional) Non-negative integer less than \code{ncol(X)}. If \code{k
== 0} (default), \code{X} is assumed to contain 1 class, which will be
centered. If \code{k >= 1}, \code{X} is assumed to contain \code{k}
classes, each of which has already been centered.}
}
\value{
A numeric vector of length \code{ncol(X)}, containing the population
  eigenvalue estimates sorted in ascending order.
}
\description{
\code{linshrink} estimates the population eigenvalues from the
  sample eigenvalues by shrinking each sample eigenvalue towards the global
  mean based on a shrinkage factor. Details in referenced publications.
}
\examples{
linshrink(X = matrix(rnorm(1e4, mean = 5), nrow = 100, ncol = 100)) # 1 class; will be centered
linshrink(X = matrix(rnorm(1e4), nrow = 100, ncol = 100), k = 1) # 1 class; no centering
}
\references{
\itemize{ \item Ledoit, O. and Wolf, M. (2004). A
  well-conditioned estimator for large-dimensional covariance matrices.
  Journal of Multivariate Analysis, 88(2) \item Ledoit, O. and Wolf, M.
  (2016). Numerical Implementation of the QuEST function. arXiv:1601.05870
  [stat.CO] }
}

