% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlts.R
\name{add.test}
\alias{add.test}
\title{Lagrange multiplier test for additivity in a timeseries}
\usage{
add.test(x, order, n.cond = FALSE)
}
\arguments{
\item{x}{A time series (vector without missing values).}

\item{order}{a scalar representing the order to be considered.}

\item{n.cond}{The number of observation to condition on.  The default is
\code{order} (must be >= \code{order})}
}
\value{
a vector is returned consisting of the asymtpotic chi-square value,
the associated d.f.  and asymptotic p.val for the test of additivity.
}
\description{
add.test is a function to test the permissibility of the additive
autoregressive model:
}
\details{
N(t) = f1(N(t-1)) + f2(N(t-2)) + ... + fd(N(t-d)) + e(t )

against the alternative:

N(t) = F(N(t-1), N(t-2), ..., N(t-d)) + e(t)

This is the Lagrange multiplier test for additivity developed by Chen et al.
(1995: test II).
}
\examples{

     data(plodia)
     add.test(sqrt(plodia), order = 3)
}
\references{
Chen, R., Liu, J.S. & Tsay, R.S. (1995) Additivity tests for
nonlinear autoregression. Biometrika, 82, 369-383. https://doi.org/10.1093/biomet/82.2.369

Bjornstad, O.N., Begon, M., Stenseth, N.C., Falck, W., Sait, S.M., &
Thompson, D.J. (1998) Population dynamics of the Indian meal moth:
demographic stochasticity and delayed regulatory mechanisms. Journal of
Animal Ecology, 67, 110-126. https://doi.org/10.1046/j.1365-2656.1998.00168.x
}
\keyword{ts}
