% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlts.R
\name{prediction.profile.ll}
\alias{prediction.profile.ll}
\alias{print.ppll}
\title{Nonlinear forecasting at varying lags using local polynomial regression.}
\usage{
prediction.profile.ll(x, step = 1:10, order = 1:5, deg = 2,
  bandwidth = c(seq(0.3, 1.5, by = 0.1), 2:10))
}
\arguments{
\item{x}{A time series without missing values.}

\item{step}{The vector of time steps for forward prediction.}

\item{order}{The candidate orders. The default is 1:5.}

\item{deg}{The degree of the local polynomial.}

\item{bandwidth}{The candidate bandwidths to be considered.}
}
\value{
An object of class "ppll" consisting of a list with the following
components: \item{step}{the prediction steps considered.} \item{CV}{the
cross-validation error.} \item{order}{the optimal order for each step.}
\item{bandwidth}{the optimal bandwidth for each step.} \item{df}{the degrees
of freedom for each step.}
}
\description{
A wrapper function around \code{ll.order} to calculate prediction profiles
(a la Sugihara and May 1990 and Yao and Tong 1994). The method uses
leave-one-out cross-validation of the local regression (with CV optimized
bandwidth) against lagged-abundances at various lags.
}
\details{
see \code{\link{ll.order}} for details.
}
\examples{

   data(plodia)

     fit <- prediction.profile.ll(sqrt(plodia), step=1:3, order=1:3,
          bandwidth = seq(0.5, 1.5, by = 0.5))

    \dontrun{plot(fit)}
}
\references{
Sugihara, G., and May, R.M. (1990) Nonlinear forecasting as a
way of distinguishing chaos from measurement error in time series. Nature
344, 734-741. https://doi.org/10.1038/344734a0

Yao, Q. and Tong, H. (1994) Quantifying the influence of initial values on
non-linear prediction.  Journal of Royal Statistical Society B, 56, 701-725.

Fan, J., Yao, Q., and Tong, H. (1996) Estimation of conditional densities
and sensitivity measures in nonlinear dynamical systems. Biometrika, 83,
189-206. https://doi.org/10.1093/biomet/83.1.189
}
\seealso{
\code{\link{ll.order}}
}
\keyword{ts}
