% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stacking.R
\name{stk}
\alias{stk}
\alias{\%stk\%}
\title{stk}
\usage{
stk(nu, mu)

nu \%stk\% mu
}
\arguments{
\item{nu}{neural network.}

\item{mu}{neural network.}
}
\value{
A stacked neural network of \eqn{\nu} and \eqn{\mu}, i.e. \eqn{\nu \boxminus \mu}


\strong{NOTE:} This is different than the one given in Grohs, et. al. 2023.
While we use padding to equalize neural networks being parallelized our
padding is via the Tun network whereas Grohs et. al. uses repetitive
composition of the i network. We use repetitive composition of the \eqn{\mathsf{Id_1}}
network. See \code{\link{Id}} \code{\link{comp}}

\strong{NOTE:} The terminology is also different from Grohs et. al. 2023.
We call stacking what they call parallelization. This terminology change was
inspired by the fact that parallelization implies commutativity but this
operation is not quite commutative. It is commutative up to transposition
of our input x under instantiation with a continuous activation function.

Also the word parallelization has a lot of baggage when it comes to
artificial neural networks in that it often means many different CPUs working
together.



\emph{Remark:} We will use only one symbol for stacking equal and unequal depth
neural networks, namely "stk". This is for usability but also that
for all practical purposes only the general stacking of neural networks
of different sizes is what is needed.

\emph{Remark:} We have two versions, a prefix and an infix version.

This operation on neural networks, called "parallelization" is found in:

A stacked neural network of nu and mu.
}
\description{
A function that stacks neural networks.
}
\examples{
create_nn(c(4,5,6)) |> stk(create_nn(c(6,7)))
create_nn(c(9,1,67)) |> stk(create_nn(c(4,4,4,4,4)))


}
\references{
Grohs, P., Hornung, F., Jentzen, A. et al. Space-time error estimates for deep
neural network approximations for differential equations. (2023).
\url{https://arxiv.org/abs/1908.03833}

And especially in:

' Definition 2.14 in Rafi S., Padgett, J.L., Nakarmi, U. (2024)
Towards an Algebraic Framework For
Approximating Functions Using Neural Network Polynomials
\url{https://arxiv.org/abs/2402.01058}
}
