% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funs.scct}
\alias{funs.scct}
\alias{scct.ct}
\alias{scct}
\title{Species Correspondence Contingency Table (SCCT)}
\usage{
scct.ct(x, lab = NULL, ties = FALSE, nnct = FALSE)

scct(dat, lab, ties = FALSE, ...)
}
\arguments{
\item{x}{The IPD matrix (if \code{nnct=FALSE}) or the NNCT (if \code{nnct=TRUE}), used in \code{scct.ct} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), default=\code{NULL} when \code{nnct=FALSE} in the function \code{scct.ct} and no default
specified for scct.}

\item{ties}{A logical argument (default=\code{FALSE}) to take ties into account or not. If \code{TRUE} a NN 
contributes \eqn{1/m} to the NN count if it is one of the \eqn{m} tied NNs of a subject.}

\item{nnct}{A logical parameter (default=\code{FALSE}). If \code{TRUE}, \code{x} is taken to be the \eqn{k \times k} NNCT, 
and if \code{FALSE}, \code{x} is taken to be the IPD matrix, used in \code{scct.ct} only.}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{scct} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function, used in \code{scct} only}
}
\value{
Returns the \eqn{k \times 2} SCCT where \eqn{k} is the number of classes in the data set.
}
\description{
Two functions: \code{scct.ct} and \code{scct}.

Both functions return the \eqn{k \times 2} species correspondence contingency table (SCCT) 
but have different arguments (see the parameter list below).

SCCT is constructed by categorizing the NN pairs according to pair type as self or mixed. 
A base-NN pair is called a self pair, if the elements of the pair are from the same class;
a mixed pair, if the elements of the pair are from different classes.
Row labels in the RCT are the class labels and the column labels are \code{"self"} and \code{"mixed"}.
The \eqn{k \times 2} SCCT (whose first column is self column with entries \eqn{S_i} and second column is mixed with entries \eqn{M_i})
is closely related to the \eqn{k \times k} nearest neighbor contingency table (NNCT) whose entries are \eqn{N_{ij}},
where \eqn{S_i=N_{ii}} and \eqn{M_i=n_i-N_{ii}} with \eqn{n_i} is the size of class \eqn{i}.

The function \code{scct.ct} returns the SCCT given the inter-point distance (IPD) matrix or data set \code{x},
and the  function \code{scct} returns the SCCT given the IPD matrix. SCCT is a \eqn{k \times 2} matrix where \eqn{k} is 
number of classes in the data set.
(See \insertCite{ceyhan:NNCorrespond2018;textual}{nnspat} for more detail,
where SCCT is labeled as CCT for correspondence contingency table).

The argument \code{ties} is a logical argument (default=\code{FALSE} for both functions) to take ties into account or not.
If \code{TRUE} a NN contributes \eqn{1/m} to the NN count if it is one of the \eqn{m} tied NNs of a subject.

The argument nnct is a logical argument for \code{scct.ct} only (default=\code{FALSE}) to determine the structure of the
argument \code{x}. If \code{TRUE}, \code{x} is taken to be the \eqn{k \times k} NNCT, and if \code{FALSE}, \code{x} is taken to be the IPD matrix.

The argument lab is the \code{vector} of class labels (default=\code{NULL} when \code{nnct=TRUE} in the function \code{scct.ct} and no default
specified for scct).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
NNCT<-nnct(ipd,cls)
NNCT

scct(Y,cls)
scct(Y,cls,method="max")

scct.ct(ipd,cls)
scct.ct(ipd,cls,ties = TRUE)
scct.ct(NNCT,nnct=TRUE)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
scct.ct(ipd,fcls)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
NNCT<-nnct(ipd,cls)
NNCT

scct(Y,cls)

scct.ct(ipd,cls)
scct.ct(NNCT,nnct=TRUE)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{nnct}}, \code{\link{tct}}, \code{\link{rct}} and \code{\link{Qsym.ct}}
}
\author{
Elvan Ceyhan
}
