% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diris2D.R
\docType{data}
\name{diris2D}
\alias{diris2D}
\title{diris2D dataset}
\format{
A data.frame with 103 samples (rows) and 3 variables (columns) named Petal.Length, Petal.Width and Species.
}
\source{
Data collected by E. Anderson (1935).
}
\usage{
data(diris2D)
}
\description{
Discretized version of the \code{iris2D} dataset.
}
\examples{

# load the dataset
data(diris2D)

# noise introduction
set.seed(9)
outdef <- sym_uni_ln(x = diris2D[,-ncol(diris2D)], y = diris2D[,ncol(diris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)

}
\references{
R. A. Fisher. \strong{The use of multiple measurements in taxonomic problems}. 
\emph{Annals of Eugenics}, 7:179-188, 1936.

E. Anderson. \strong{The irises of the Gaspe Peninsula}. 
\emph{Bulletin of the American Iris Society}, 59:2-5, 1935.
}
\seealso{
\code{\link{iris2D}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
\keyword{datasets}
