% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/031_sigb_uni_ln.R
\name{sigb_uni_ln}
\alias{sigb_uni_ln}
\alias{sigb_uni_ln.default}
\alias{sigb_uni_ln.formula}
\title{Sigmoid-bounded uniform label noise}
\usage{
\method{sigb_uni_ln}{default}(x, y, level, order = levels(y), sortid = TRUE, ...)

\method{sigb_uni_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double vector with the noise levels in [0,1] to be introduced into each class.}

\item{order}{a character vector indicating the order of the classes (default: \code{levels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Sigmoid-bounded uniform label noise} into a classification dataset.
}
\details{
\emph{Sigmoid-bounded uniform label noise} generates bounded instance-dependent and 
label-dependent label noise at random using a weight for each sample in 
the dataset to compute its noise probability through a sigmoid function. 
Note that this noise model considers the maximum noise level per class given by 
\code{level}, so the current noise level in each class may be lower than that specified. 
The order of the class labels is determined by \code{order}.
}
\note{
Noise model adapted from the papers in References to multiclass data.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- sigb_uni_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], 
                      level = c(0.1, 0.2, 0.3))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- sigb_uni_ln(formula = Species ~ ., data = iris2D, 
                      level = c(0.1, 0.2, 0.3))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
J. Cheng, T. Liu, K. Ramamohanarao, and D. Tao. 
\strong{Learning with bounded instance and label-dependent label noise}. 
In \emph{Proc. 37th International Conference on Machine Learning}, 
volume 119 of PMLR, pages 1789-1799, 2020.
url:\url{http://proceedings.mlr.press/v119/cheng20c.html}.
}
\seealso{
\code{\link{larm_uni_ln}}, \code{\link{hubp_uni_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
