% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/037_sym_con_ln.R
\name{sym_con_ln}
\alias{sym_con_ln}
\alias{sym_con_ln.default}
\alias{sym_con_ln.formula}
\title{Symmetric confusion label noise}
\usage{
\method{sym_con_ln}{default}(x, y, level, sortid = TRUE, ...)

\method{sym_con_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Symmetric confusion label noise} into a classification dataset.
}
\details{
\emph{Symmetric confusion label noise} considers that the mislabeling probability for each 
class is \code{level}. It obtains the confusion matrix from the dataset, which is 
row-normalized to estimate the transition matrix and get the probability of selecting each class 
when noise occurs.
}
\note{
Noise model adapted from the papers in References, considering C5.0 as classifier.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- sym_con_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- sym_con_ln(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
D. Ortego, E. Arazo, P. Albert, N. E. O’Connor, and K. McGuinness. 
\strong{Towards robust learning with different label noise distributions}. 
In \emph{Proc. 25th International Conference on Pattern Recognition}, pages 7020-7027, 2020.
\doi{10.1109/ICPR48806.2021.9412747}.
}
\seealso{
\code{\link{sym_cen_ln}}, \code{\link{glev_uni_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
