% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_gtf_to_genes.R
\name{cast_gtf_to_genes}
\alias{cast_gtf_to_genes}
\title{Function to extract exon names and positions from a gtf file}
\usage{
cast_gtf_to_genes(filename, feature = "exon", att_of_interest = "gene_id", ...)
}
\arguments{
\item{filename}{path to the gtf file}

\item{feature}{the feature type name to filter the feature (3rd) column of the gtf/gff file;
default is exon}

\item{att_of_interest}{the attribute to extract from the last column of the gtf/gff file;
default in gene_id}

\item{...}{arguments passed on to other methods}
}
\value{
A tibble of the ids, gene names, chromosomes, start and end positions
of each exon found in the gtf file.
}
\description{
This function is used to extract all exons and their positions
in the genome from an input gtf file.
}
\examples{
fl <- system.file("extdata", "example.gtf.gz", package="Rsamtools", mustWork=TRUE)
cast_gtf_to_genes(fl)
}
