% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{fetch_nomis}
\alias{fetch_nomis}
\title{Fetch Data from Nomis}
\usage{
fetch_nomis(
  id,
  time = NULL,
  date = NULL,
  geography = NULL,
  sex = NULL,
  measures = NULL,
  exclude_missing = FALSE,
  select = NULL,
  ...,
  .progress = interactive()
)
}
\arguments{
\item{id}{Dataset ID (required)}

\item{time}{Time range using keywords or specific dates}

\item{date}{Specific dates (alternative to time)}

\item{geography}{Geography code(s)}

\item{sex}{Sex/gender code(s)}

\item{measures}{Measure code(s)}

\item{exclude_missing}{Remove missing values}

\item{select}{Column names to include}

\item{...}{Additional dimension filters}

\item{.progress}{Show progress bar for multi-part queries}
}
\value{
Tibble with requested data
}
\description{
Main function to download data from Nomis datasets.
}
\examples{
\donttest{
fetch_nomis(
  "NM_1_1",
  time = "latest",
  geography = "TYPE499",
  measures = 20100,
  sex = 7
)

fetch_nomis(
  "NM_1_1",
  date = c("latest", "prevyear"),
  geography = c("2092957697", "2092957698"),
  measures = 20100
)
}
}
