% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transparent.R
\name{ACE_bounds_triangle.plot}
\alias{ACE_bounds_triangle.plot}
\title{"Triangle" plot of the posterior bounds for the Average Causal Effect (ACE).}
\usage{
ACE_bounds_triangle.plot(bounds, title.txt)
}
\arguments{
\item{bounds}{Posterior bounds from the ACE_bounds_posterior function.}

\item{title.txt}{Title for the plot.}
}
\value{
A "triangle" plot.
}
\description{
Plot of the posterior upper bound for the Average Causal Effect (ACE)
   against the corresponding lower bound.
}
\examples{
ace.bnds.lipid <- ACE_bounds_posterior(158, 14, 0, 0, 52, 12, 23, 78,
     prior = c( rep(1, 2), rep(0, 2), rep(1, 4)))
ACE_bounds_triangle.plot(ace.bnds.lipid, "Bounds on ACE for Lipid Data")
\dontrun{
ace.bnds.lipid <- ACE_bounds_posterior(158, 14, 0, 0, 52, 12, 23, 78,
     prior = c( rep(1, 2), rep(0, 2), rep(1, 4)), num.sims = 2e4)
ACE_bounds_triangle.plot(ace.bnds.lipid, "Bounds on ACE for Lipid Data") }
}

