% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_results.R
\name{plot_drel}
\alias{plot_drel}
\title{Plot reliability estimates over age}
\usage{
plot_drel(drel, ncol = 3, nrow = 2, ...)
}
\arguments{
\item{drel}{a \code{Drel} object (created with \code{\link[=different_rel]{different_rel()}}).}

\item{ncol}{number of plots per row (default: \code{3}).}

\item{nrow}{number of plots per column (default: \code{2}).}

\item{...}{additional arguments passed to plotting functions.}
}
\value{
graphical output and the \code{ggplot} object used to create it.
}
\description{
\code{plot_drel()} plots reliability estimates as a function of age,
based on different window widths, using a \code{Drel} object.
}
\examples{
\donttest{
data("ids_kn_data")

rel_int <- different_rel(
  data           = ids_kn_data,
  item_variables = colnames(ids_kn_data),
  age_name       = "age_years",
  step_window    = c(0.5, 1, 2, 5, 10, 20),
  min_agegroup   = 5,
  max_agegroup   = 20,
  step_agegroup  = c(0.5, 1, 1.5, 2)
)

plot_drel(rel_int, ncol = 2)
}

}
\seealso{
\code{\link[=different_rel]{different_rel()}}
}
