% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npMeanPaired.R
\name{npMeanPaired}
\alias{npMeanPaired}
\title{A test for the mean difference between two bounded random variables given
matched pairs.}
\usage{
npMeanPaired(x1, x2, lower = 0, upper = 1, alpha = 0.05,
  alternative = "two.sided", epsilon = 1 * 10^(-6),
  iterations = 5000, max.iterations = 100000)
}
\arguments{
\item{x1, x2}{the (non-empty) numerical data vectors which contain the
variables to be tested. The first values of the vectors are assumed to be
the first matched pair of observations, the second values the second
matched pair and so on.}

\item{lower, upper}{the theoretical lower and upper bounds on the data
outcomes known ex-ante before gathering the data.}

\item{alpha}{the type I error.}

\item{alternative}{a character string describing the alternative
hypothesis, can take values "greater", "less" or "two.sided".}

\item{epsilon}{the tolerance in terms of probability of the Monte Carlo
simulations.}

\item{iterations}{the number of iterations used, should not be changed if
the exact solution should be derived}

\item{max.iterations}{the maximum number of iterations that should be
carried out. This number could be increased to achieve greater accuracy in
cases where the difference between the threshold probability and theta is
small. Default: \code{10000}}
}
\value{
A list with class "nphtest" containing the following components:

\item{method}{ a character string indicating the name and type of the test
that was performed.  } \item{data.name}{ a character string giving the
name(s) of the data.  } \item{alternative}{ a character string describing
the alternative hypothesis.  } \item{estimate}{ the sample means of the
given data.  } \item{probrej}{ numerical estimate of the rejection
probability of the randomized test, derived by taking an average of
\code{iterations} realizations of the rejection probability.  }
\item{bounds}{ the lower and upper bounds of the variables.  }
\item{null.value}{ the specified hypothesized value of the difference of
the variable means.  } \item{alpha}{ the type I error.  } \item{theta}{ the
parameter that minimizes the type II error.  } \item{pseudoalpha}{
\code{theta}*\code{alpha}, this is the level used when calculating the
average rejection probability during the iterations.  } \item{rejection}{
logical indicator for whether or not the null hypothesis can be rejected.
} \item{iterations}{ the number of iterations that were performed.  }
}
\description{
This test requires that the user knows bounds before gathering the data
such that the properties of the data generating process imply that all
observations will be within these bounds. The data input consists of pairs
of observations, each pair consisting of an observation of each random
variable, different pairs being independently generated. No further
distributional assumptions are made.
}
\details{
Under alternative = "greater", it is a test of the null hypothesis
\eqn{H_0: E(x_1) \le E(x_2)} against the alternative hypothesis \eqn{H_1:
E(x_1) > E(x_2)}.

This test uses the known bounds of the variables to transform the data into
[0, 1]. Then a random transformation is used to turn the data into
binary-valued variables. On this variables the exact McNemar Test with
level \code{pseudoalpha} is performed and the result recorded. The random
transformation and the test are then repeated \code{iterations} times. If
the average rejection probability \code{probrej} of the iterations is at
least \code{theta}, then the null hypothesis is rejected. If however
\code{probrej} is too close to the threshold \code{theta} then the number
of iterations is increased. The algorithm keeps increasing the number of
iterations until the bound on the mistake involved by running these
iterations is below \code{epsilon}. This error epsilon is incorporated into
the overall level \code{alpha} in order to maintain that the test is exact.

\code{theta} (and a value \code{mu} of the difference between the two means
in the set of the alternative hypothesis) is found in an optimization
procedure. \code{theta} and \code{mu} are chosen as to maximize the set of
data generating processes belonging to the alternative hypothesis that
yield type II error probability below 0.5. Please see the cited paper below
for further information.
}
\examples{

## test whether pain after the surgery is less than before the surgery
data(pain)
npMeanPaired(pain$before, pain$after, lower = 0, upper = 100)

## when the computer was used in the surgery
before_pc <- pain[pain$pc == 1, "before"]
after_pc <- pain[pain$pc == 1, "after"]
npMeanPaired(before_pc, after_pc, lower = 0, upper = 100)

## test whether uncertainty decreased from the first to the second round
data(uncertainty)
npMeanPaired(uncertainty$w1, uncertainty$w2, upper = 60) ## or
with(uncertainty, npMeanPaired(w1, w2, upper = 60))

}
\references{
Schlag, Karl H. 2008, A New Method for Constructing Exact Tests
without Making any Assumptions, Department of Economics and Business
Working Paper 1109, Universitat Pompeu Fabra. Available at
\url{https://ideas.repec.org/p/upf/upfgen/1109.html}.
}
\seealso{
\url{https://homepage.univie.ac.at/karl.schlag/statistics.php}
}
\author{
Karl Schlag, Christian Pechhacker and Oliver Reiter
}
\keyword{mean}
\keyword{pairwise}
\keyword{test}
