% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConfInterval.R
\name{ConfInterval}
\alias{ConfInterval}
\title{Confidence Interval}
\usage{
ConfInterval(object, level, side="two.sided",
adjust=NULL)
}
\arguments{
\item{object}{a fitted model object from ncda().}

\item{level}{the confidence level required.}

\item{side}{a character string specifying the side of the confidence bound,
must be one of "two.sided" (default), "left" or "right".}

\item{adjust}{an optional character string specifying the multiple adjustment method,
by default there is no adjustment, if specified, must be one of "Bonferroni" or "Working-Hotelling".
You can specify just the initial letter.}
}
\value{
A list or a vector. If the confidence interval is two-sided, lower and
upper bounds are stored in lists for each nonparametric effect size estimate.
Otherwise, the lower/upper bounds are stored in vectors in the order of the effect size estimates.
}
\description{
Construct confidence intervals for effect sizes.
}
\examples{
skin_analysis <- ncda(score~tx, skin, intervention, subject,
                      indicator=c("control","treatment"),
                      Contrast=matrix(c(1,-1), nrow = 1))
ConfInterval(skin_analysis,0.95)
\donttest{
ARTIS_analysis <- ncda(emot_pqol~tx, ARTIS, intervention, homeid,
                       indicator = c("0","1"))
ConfInterval(ARTIS_analysis,0.95)
ConfInterval(ARTIS_analysis,0.95,"two.sided","B")
ConfInterval(ARTIS_analysis,0.95,"left","W")
}
}
