% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Splinefit.R
\name{Spline.fit}
\alias{Spline.fit}
\title{Polynomial-spline fit with equally-spaced knots}
\usage{
Spline.fit(Xint, Xvec, Yvec, nKnots = 2, Degree = 3, Wt = 1)
}
\arguments{
\item{Xint}{a vector of x interval to generate the local linear fit}

\item{Xvec, Yvec}{numeric vectors of data values, Xvec and Yvec must have the same length.}

\item{nKnots}{number of equally-spaced knots}

\item{Degree}{degree of polynomial splines}

\item{Wt}{a weight vector or a constant. For longitudinal data, Wt=1/N corresponds to measurement uniform weight and Wt=1/(nni) corresponds subject uniform weight.}
}
\description{
Polynomial-spline fit with equally-spaced knots
}
\references{
{ Wu, C.O. and Tian, X.   Nonparametric Models for Longitudinal Data. Chapman & Hall/CRC.
            To appear.}
}
