% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_model_7.R
\name{imSeven}
\alias{imSeven}
\title{Item Model 7}
\usage{
imSeven(vOne = 1, vTwo = 3, items, seed = 1, logic = "one",
  random = FALSE)
}
\arguments{
\item{vOne}{The first value in the complex coefficient (x). Can be a sequence of values or a specific value.}

\item{vTwo}{The second value in the complex coefficient (y). Can be a sequence of values or a specific value.}

\item{items}{Generate a random mix of items.}

\item{seed}{To get the same random sampling of items}

\item{logic}{"one" or "two"}

\item{random}{If random=FALSE, the items will follow in sequential order.}
}
\description{
This uses item model 7 to create number series items - Identification of complex coefficients of change
}
\details{
This function creates number series that is a combination of Arithmetic, Linear and Complex coefficient. Ability to identify complex coefficients; the coefficient of change involves a combination of arithmetic operations (e.g. addition and multiplication) applied serially.\cr
There are two logic to calculate the number series.
First logic of complex coefficient = i*x+y.\cr
Second logic of complex coefficient = (i+x)*y. \cr.
Example: Each element in the sequence is derived from the preceding by adding two and multiplying the result by two. (2 8 20 44 92 (188)).
}
\examples{

#Draws 5 items randomly.
imSeven(vOne=1,vTwo=3,items=5,seed=2,logic="one",random=TRUE)

# Calculates all combinations
# Items and seed arg is ignored.
imSeven(vOne=1:2,vTwo=1:3,items=5,seed=2,logic="one",random=FALSE)


}
\author{
Aiden Loe and Filip Simonfy
}
