% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMatchingAnnotations.R
\name{getMatchingAnnotations}
\alias{getMatchingAnnotations}
\title{Gets a list of annotations that match a particular pattern}
\usage{
getMatchingAnnotations(
  labbcat.url,
  expression,
  page.length = NULL,
  page.number = NULL
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{expression}{An expression that determines which annotations match. This must
match by either id or layer.id.
The expression language is currently not well defined, but is based on JavaScript
syntax. e.g.
\itemize{
\item \code{id == 'ew_0_456'}
\item \verb{layerId == 'orthography' && !/th[aeiou].+/.test(label)}
\item \verb{graph.id == 'AdaAicheson-01.trs' && layer.id == 'orthography' && start.offset &gt; 10.5}
\item \verb{layer.id == 'utterance' && all('word').includes('ew_0_456')}
\item \verb{layerId = 'utterance' && labels('orthography').includes('foo')}
\item \verb{layerId = 'utterance' && labels('participant').includes('Ada')}
}}

\item{page.length}{The maximum number of IDs to return, or null to return all}

\item{page.number}{The zero-based page number to return, or null to return the first page}
}
\value{
A list of annotations.
}
\description{
Returns the annotations in the corpus that match the given expression.
}
\details{
The results can be exhaustive, by omitting page.length and
page.number, or they  can be a subset (a 'page') of results, by
given page.length and page.number values.
}
\examples{
\dontrun{
## get all topic annotations whose label includes the word 'quake'
quake.topics <- getMatchingAnnotations(
                   labbcat.url, "layer.id == 'topic' && /.*quake.*/.test(label)")
}

}
\seealso{
\link{countMatchingAnnotations}
}
\keyword{annotation}
\keyword{expression}
