% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/oaTemplate.R
\name{oaTemplate}
\alias{oaTemplate}
\title{Create a OA Plot Template}
\usage{
oaTemplate(xlim, ylim, xgrid = NULL, ygrid = NULL, xlab = NULL,
  ylab = NULL, main = NULL, bgCol = gray(0.9), col.axis = gray(0.6),
  col.lab = gray(0.4), col.main = gray(0.3), cex.axis = 0.7,
  cex.lab = 1, cex.main = 1.5, xaxs = "r", yaxs = "r", add = FALSE,
  box = FALSE, box.col = "black", box.lwd = 1, ylabels = NULL,
  xlabels = NULL, buffer = 0, gridLabelBuffer = 0.01, ylabBuffer = 0.1,
  xlabBuffer = 0.08, mainBuffer = 0.07)
}
\arguments{
\item{xlim}{x limits for the plot}

\item{ylim}{y limits for the plot}

\item{xgrid}{values at which to draw the x axis gridlines}

\item{ygrid}{values at which to draw the y axis gridlines}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{main}{an overall title for the plot}

\item{bgCol}{background color for the plot}

\item{col.axis}{color for the axis labels}

\item{col.lab}{color for the xlab and ylab titles}

\item{col.main}{color for the main title}

\item{cex.axis}{size of the axis labels}

\item{cex.lab}{size of the xlab and ylab titles}

\item{cex.main}{size of the main title}

\item{xaxs}{The style of axis interval calculation to be used for the x-axis. Possible values are "r", "i".
Style "r" (regular) first extends the data range by 4 percent at each end and then finds an axis with pretty labels that fits within the extended range.
Style "i" (internal) just finds an axis with pretty labels that fits within the original data range.}

\item{yaxs}{The style of axis interval calculation to be used for the y-axis. See xaxs above.}

\item{add}{A logical value specifying whether to add the template to an existing plot. If FALSE, a
new plot will be created}

\item{box}{binary specifying whether to draw a bounding box around the plot}

\item{box.col}{color of the bounding box}

\item{box.lwd}{width of the bounding box lines}

\item{ylabels}{labels to print at the y tickmarks}

\item{xlabels}{labels to print at the x tickmarks}

\item{buffer}{optional buffer around all edges of the plot (as a percentage of the plot)}

\item{gridLabelBuffer}{buffer between plot and grid labels (as a proportion of plotting range)}

\item{ylabBuffer}{distance between plot and y-axis title, as proportion of total plot width}

\item{xlabBuffer}{distance between plot and x-axis title, as proportion of total plot height}

\item{mainBuffer}{distance between plot and main title, as proportion of total plot height}
}
\value{
none, objects are plotted to the current device
}
\description{
Create a OA Plot Template
}
\examples{
par(plt = c(0, 1, 0, 1))
oaTemplate(xlim = c(0, 10), ylim = c(20, 50), add = FALSE, xlab = "X Label", ylab = "Y Label",
		main = "Main Title")
}
\author{
Jason Waddell
}

