% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_metadataformats.R
\name{list_metadataformats}
\alias{list_metadataformats}
\title{List available metadata formats from various providers.}
\usage{
list_metadataformats(
  url = "http://api.gbif.org/v1/oai-pmh/registry",
  id = NULL,
  ...
)
}
\arguments{
\item{url}{(character) OAI-PMH base url. Defaults to the URL for
arXiv's OAI-PMH server (http://export.arxiv.org/oai2)
or GBIF's OAI-PMH server (http://api.gbif.org/v1/oai-pmh/registry)}

\item{id}{The OAI-PMH identifier for the record. Optional.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
List available metadata formats from various providers.
}
\examples{
\dontrun{
list_metadataformats()

# no metadatformats for an identifier
list_metadataformats(id = "9da8a65a-1b9b-487c-a564-d184a91a2705")

# metadatformats available for an identifier
list_metadataformats(id = "ad7295e0-3261-4028-8308-b2047d51d408")
}
}
