% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_runs.R
\name{runs_submit_tool_outputs_request}
\alias{runs_submit_tool_outputs_request}
\title{API runs: submit tool outputs to run}
\usage{
runs_submit_tool_outputs_request(
  thread_id,
  run_id,
  tool_outputs,
  api_key = api_get_key()
)
}
\arguments{
\item{thread_id}{string, the ID of the thread (https://platform.openai.com/docs/api-reference/threads) to which this
run belongs}

\item{run_id}{string, the ID of the run that requires the tool output submission}

\item{tool_outputs}{list, a list of tools for which the outputs are being submitted.
\preformatted{
list(
  # string (optional), the ID of the tool call in the required_action
  # object within the run object the output is being submitted for.
  tool_call_id = 
  # string (optional), the output of the tool call to be
  # submitted to continue the run
  output = 
)}}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
When a run has the status: "requires_action" and required_action.type is submit_tool_outputs, this endpoint can be
used to submit the outputs from the tool calls once they're all completed. All outputs must be submitted in a single
request. To get more details, visit https://platform.openai.com/docs/api-reference/runs/submitToolOutputs
https://platform.openai.com/docs/assistants
}
