% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth.R
\name{depthMetrics}
\alias{depthMetrics}
\title{Calculate order book summary statistics/metrics.}
\usage{
depthMetrics(depth, bps = 25, bins = 20)
}
\arguments{
\item{depth}{Price level cumulative depth calculated by priceLevelVolume()}

\item{bps}{Width (in BPS) for each interval/bin}

\item{bins}{Number of intervals +- the best bid/ask to aggregate.}
}
\value{
data.frame containing order book summary statistics.
}
\description{
This function calculates various summary statistics describing the state of
the limit order book after every event. The metrics are intended to quantify
the "shape" of the order book through time. Currenly the following metrics
are calculated:
}
\details{
\preformatted{
  [timestamp,
   best.bid.price, best.bid.vol, bid.vol25:500bps,
   best.ask.price, best.ask.vol, ask.vol25:500bps,]

where timestamp = time of order book state change
 best.bid.price = current best bid price
 best.bid.vol = current amount of volume at the best bid
 bid.vol25:500bps = amount of volume available > -25bps and <= best bid
                    until > 500bps <= 475bps.
   ... the same pattern is then repeated for the ask side.
}
}
\author{
phil
}
\keyword{internal}

