% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plotVolumeMap}
\alias{plotVolumeMap}
\title{Visualise flashed-limit order volume.}
\usage{
plotVolumeMap(events, action = "deleted", type = c("flashed-limit"),
  start.time = min(events$timestamp), end.time = max(events$timestamp),
  price.from = NULL, price.to = NULL, volume.from = NULL,
  volume.to = NULL, volume.scale = 1, log.scale = F)
}
\arguments{
\item{events}{Limit order \code{\link{events}} data.frame.}

\item{action}{"deleted" for cancelled volume, "added" for added volume.}

\item{type}{default = c("flashed-limit"). Set of types.}

\item{start.time}{Plot events from this time onward.}

\item{end.time}{Plot events up until this time.}

\item{price.from}{Plot events with price levels >= this value.}

\item{price.to}{Plot events with price levels <= this value.}

\item{volume.from}{Plot events with volume >= this value relevant to
volume.scale}

\item{volume.to}{Plot events with volume <= this value relevant to
volume scale.}

\item{volume.scale}{Volume scale factor.}

\item{log.scale}{If true, plot volume on logarithmic scale.}
}
\description{
Plots the points at which volume was added or removed from the limit order
book.
}
\details{
A flashed limit-order is a "fleeting" limit order: an order was added,
then removed (usually within a very short period of time). This plot is
especially useful for identifying individual trading algorithms by price and
volume.
}
\examples{

# plot all fleeting limit order volume using logarithmic scale.
with(lob.data, plotVolumeMap(events, volume.scale=10^-8, log.scale=TRUE))

# "fleeting" order volume within 1 hour range up until 10 units of volume.
with(lob.data, plotVolumeMap(events, volume.scale=10^-8,
    start.time=as.POSIXct("2015-05-01 02:30:00.000", tz="UTC"),
    end.time=as.POSIXct("2015-05-01 03:30:00.000", tz="UTC"),
    volume.to=10))

}
\author{
phil
}

