% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{binApply2D}
\alias{binApply2D}
\title{Apply a Function to Matrix Data}
\usage{
binApply2D(x, y, f, xbreaks, ybreaks, FUN, include.lowest = FALSE, ...)
}
\arguments{
\item{x}{a vector of numerical values.}

\item{y}{a vector of numerical values.}

\item{f}{a vector of data to which \code{FUN} will be applied.}

\item{xbreaks}{values of \code{x} at the boundaries between the
bins; calculated using \code{\link[=pretty]{pretty()}} if not supplied.}

\item{ybreaks}{as \code{xbreaks}, but for \code{y}.}

\item{FUN}{function that is applied to the \code{f} values
in each (x,y) bin.  This must take two numeric vectors
as input, and return a single numeric value.}

\item{include.lowest}{logical value indicating whether to include
\code{x} values that equal \code{xbreaks[1]} and \code{y} values that equal
\code{ybreaks[1]}.  See \dQuote{Details}.}

\item{\dots}{optional arguments to pass to \code{FUN}.}
}
\value{
A list with the following elements:
\code{xbreaks} and \code{ybreaks} as used, mid-points
\code{xmids} and \code{ymids}, and \code{result}, a matrix containing the
result of applying \code{FUN()} to the \code{f} values
in the designated bins.
}
\description{
The function \code{FUN} is applied to \code{f} in bins specified by
\code{xbreaks} and \code{ybreaks}.
}
\details{
The division into bins is done with \code{\link[=cut]{cut()}}, to which \code{include.lowest}
is passed. By default, the \code{x} bins are open at the left and closed
on the right, and the \code{y} bins are open at the bottom and closed
at the top.  However, if \code{include.lowest} is TRUE, then those
boundary points are included in the calculation.
}
\seealso{
Other bin-related functions: 
\code{\link{binApply1D}()},
\code{\link{binAverage}()},
\code{\link{binCount1D}()},
\code{\link{binCount2D}()},
\code{\link{binMean1D}()},
\code{\link{binMean2D}()}
}
\author{
Dan Kelley
}
\concept{bin-related functions}
