% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oce-deprecated}
\alias{oce-deprecated}
\alias{oce-defunct}
\title{Deprecated and Defunct Elements of the oce Package}
\description{
Certain functions and function arguments are still provided for
compatibility with older versions of \CRANpkg{oce}, but will be removed soon.
The \CRANpkg{oce} scheme for removing functions is similar to that used by
\code{Bioconductor}: items are marked as "deprecated" in one release, marked as
"defunct" in the next, and removed in the next after that. This goal is to provide a
gentle migration path for users who keep their packages reasonably
up-to-date.
}
\details{
The following are marked "deprecated" in the present CRAN release of \CRANpkg{oce}.
Please use the replacement functions as listed below. The upcoming CRAN
release of \CRANpkg{oce} will mark these as "defunct", which is the
last step before outright removal.

\tabular{lllll}{
\strong{Deprecated}            \tab \strong{Replacement}   \tab \strong{Deprecated}  \tab \strong{Defunct} \tab \strong{Removed} \cr
}

The following are marked "defunct", so calling them in the
the present version produces an error message that hints at a replacement
function. Once a function is marked "defunct" on one CRAN release, it will
be slated for outright deletion in some subsequent release.

\tabular{lll}{
\strong{Defunct}         \tab \strong{Replacement}                \tab \strong{Version}\cr
}

The following functions were removed after having been marked as "deprecated"
in at least one CRAN release, and possibly as "defunct" in at least
one CRAN release.  (The version number in the table is the first
version to lack the named function.)

\tabular{lll}{
\strong{Function}        \tab \strong{Replacement}                \tab \strong{Version}\cr
\code{addColumn()}       \tab \code{\link[=oceSetData]{oceSetData()}}                 \tab 1.1-2      \cr
\code{ctdAddColumn()}    \tab \code{\link[=oceSetData]{oceSetData()}}                 \tab 1.1-2      \cr
\code{ctdUpdateHeader()} \tab \code{\link[=oceSetMetadata]{oceSetMetadata()}}             \tab 1.1-2      \cr
\code{findInOrdered()}   \tab \code{\link[=findInterval]{findInterval()}}               \tab 1.1-2      \cr
\code{makeSection()}     \tab \code{\link[=as.section]{as.section()}}                 \tab 0.9.24     \cr
\code{mapMeridians()}    \tab \code{\link[=mapGrid]{mapGrid()}}                    \tab 1.1-2      \cr
\code{mapZones()}        \tab \code{\link[=mapGrid]{mapGrid()}}                    \tab 1.1-2      \cr
\code{oce.as.POSIXlt()}  \tab \code{\link[lubridate:parse_date_time]{lubridate::parse_date_time()}} \tab 1.1-2      \cr
\code{renameData()}      \tab \code{\link[=oceRenameData]{oceRenameData()}}              \tab 1.7-9      \cr
\code{trimString()}      \tab \code{\link[=trimws]{trimws()}}                     \tab 1.8-2      \cr
}

Several \dQuote{oce} function arguments are considered "defunct", which
means they will be removed in the next CRAN release. They are as follows.
\itemize{
\item The \code{fill} argument of \code{\link[=mapPlot]{mapPlot()}} was confusing
to users, so it was designated as deprecated in June 2016.
(The confusion stemmed from subtle differences between
\code{\link[=plot]{plot()}} and \code{\link[=polygon]{polygon()}}, and the problem is that
\code{\link[=mapPlot]{mapPlot()}} can use either of these functions, according
to whether coastlines are to be filled.)
The functionality is preserved, in the \code{col} argument.
}
}
\seealso{
The \dQuote{Bioconductor} scheme for removing functions is
described at
\verb{https://www.bioconductor.org/developers/how-to/deprecation/} and it is
extended here to function arguments.
}
