% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reproject}
\alias{reproject}
\alias{reproject.sf}
\alias{reproject.stars}
\title{Re-projecting spatial objects to new epsg}
\usage{
reproject(obj, epsg, ...)

\method{reproject}{sf}(obj, epsg, ...)

\method{reproject}{stars}(obj, epsg, ...)
}
\arguments{
\item{obj}{The sf or stars object to be re-projected.}

\item{epsg}{The projection (currently only: \code{"3031"}, or \code{"3995"}).}

\item{...}{Currently not supported.}
}
\value{
sf or stars object
}
\description{
Easy re-projecting of the epsg of \code{\link[sf:st_as_sf]{sf}} and
\code{\link[stars:st_as_stars]{stars}} objects.
}
\examples{

if (interactive()) {
# get data
NOAA <- get_NOAA("temperature", 1, "annual")

# reproject data with new epsg
reproject(NOAA, 3031)
}
}
