% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_data.frame.R
\name{group_data.frame}
\alias{group_data.frame}
\title{Grouping of a \code{data.frame}}
\usage{
group_data.frame(df, by, keep_by = TRUE)
}
\arguments{
\item{df}{[\code{data.frame}]\cr
A \code{data.frame}.}

\item{by}{[\code{character(1)}]\cr
The name of a column of \code{df} to group by.}

\item{keep_by}{[\code{logical(1)}]\cr
Keep the grouping column \code{by}?}
}
\value{
A \code{list} of \code{data.frame}s, subsets of \code{df}.
}
\description{
This function groups a \code{data.frame} according to values of one column.
}
\examples{
df <- data.frame("label" = c("A", "B"), "number" = 1:10)
group_data.frame(df = df, by = "label")
group_data.frame(df = df, by = "label", keep_by = FALSE)
}
\seealso{
Other data.frame helpers: 
\code{\link{delete_columns_data.frame}()},
\code{\link{occurrence_info}()},
\code{\link{round_data.frame}()}
}
\concept{data.frame helpers}
\keyword{transformation}
