% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpart.R
\name{rpart_exposure}
\alias{rpart_exposure}
\title{Poisson Recursive Partitioning and Regression Trees with Exposures}
\usage{
rpart_exposure(
  formula,
  data,
  exposure_col = "exposure",
  weights = NULL,
  control,
  cost,
  shrink = 1,
  ...
)
}
\arguments{
\item{formula}{A model formula that contains a single response variable on
the left-hand side.}

\item{data}{Optional. A data frame containing variables used in the model.}

\item{exposure_col}{Character string. The name of a column in \code{data}
containing exposures.}

\item{weights}{Optional weights to use in the fitting process.}

\item{control}{A list of hyperparameters. See \code{\link[rpart:rpart.control]{rpart::rpart.control()}}.}

\item{cost}{A vector of non-negative costs for each variable in the model.}

\item{shrink}{Optional parameter for the splitting function. Coefficient of
variation of the prior distribution.}

\item{...}{Alternative input for arguments passed to
\code{\link[rpart:rpart.control]{rpart::rpart.control()}}.}
}
\value{
An \code{rpart} model
}
\description{
This function is a wrapper around \code{\link[rpart:rpart]{rpart::rpart()}} for Poisson regression
trees using weighted exposures (observation times).
}
\details{
Outside of the \code{tidymodels} ecosystem, \code{rpart_exposure()} has no
advantages over \code{\link[rpart:rpart]{rpart::rpart()}} since that function allows for exposures to
be specified in the formula interface by passing \code{cbind(exposure, y)} as a
response variable.

Within \code{tidymodels}, \code{rpart_exposure()} provides an advantage because
it will ensure that exposures are included in the data whenever resamples are
created.

The \code{formula}, \code{data}, \code{weights}, \code{control}, and \code{cost} arguments have the
same meanings as \code{\link[rpart:rpart]{rpart::rpart()}}. \code{shrink} is passed to \code{\link[rpart:rpart]{rpart::rpart()}}'s
\code{parms} argument via a named list. See that function's documentation for full
details.
}
\examples{
if (interactive()) {
  rpart_exposure(deaths ~ age_group + gender, us_deaths,
                 exposure_col = "population")
}

}
\seealso{
\code{\link[rpart:rpart]{rpart::rpart()}}
}
